**************************************************************************************************************************************************************************************************
******* DIESER CODE REPRODUZIERT DIE BEFUNDE DES AUFSATZES "Die wahrgenommene Entwicklung der sozialen Gerechtigkeit und Wahlentscheidungen bei der Bundestagswahl 2017 " ************************
*************************************************************************** AUTOR: NILS STEINER **************************************************************************************************
**************************************************************************************************************************************************************************************************

********************************************** Instruktionen ********************************************
* 1.) Download der Daten:
    
	* GLES 2017, Nachwahlquerschnitt
	* Roßteutscher, Sigrid; Schmitt-Beck, Rüdiger; Schoen, Harald; Weßels, Bernhard; Wolf, Christof; Wagner, Aiko; Melcher, Reinhold; Giebler, Heiko (2019): Nachwahl-Querschnitt (GLES 2017). GESIS Datenarchiv, Köln. ZA6801 Datenfile Version 4.0.1, doi:10.4232/1.13235
	* Download des Datensatzes und zugehörigen do-files zur Definition fehlender Werte
		* ZA6801_de_v4-0-1.dta
	
* 2.) Speichern der Datensätze und do-files in einem Ordner und festlegen als Arbeitsverzeichnis
* 3.) Falls nötig fehlende ados und graph schemes installieren:
			* ssc install estout
			* ssc install fre
			* ssc install blindschemes, replace all
	
* 4.) Ausführen des Codes mit Stata 15.1.
**********************************************************************************************************



**********************************************************************************************************
******************* Allgemeine Einstellungen und Vorbereitungen ******************************************
**********************************************************************************************************
	clear all
	version 15.1

	

**********************************************************************************************************
******************* Laden und Verarbeitung des Datensatzes ***********************************************
**********************************************************************************************************
	* Öffnen des Datensatzes: Nachwahlquerschnitt der GLES zur Bundestagswahl 2017
	use ZA6801_de_v4-0-1.dta, replace

	* Ausführen des Befehls aus dem do-file (ZA6801_de_missing.do) zur Anpassung der fehlenden Werte an Stata
	**** SPSS Missings in STATA Format umbennenen (Numerisch) ****
	foreach var of varlist _all {
		capture confirm numeric var `var'
		if !_rc {
			mvdecode `var', mv(-71=.p \-72=.o \-81=.n \-82=.m \-83=.l ///
					 \-84=.k \-85=.j \-86=.i \-92=.h \-93=.g ///
					 \-94=.f \-95=.e \-96=.d \-97=.c \-98=.b ///
					 \-99=.a)
			local lab: value label `var'
			if "`lab'"!="" {
				label define `lab' ///
				.a"keine Angabe" ///
				.b"weiss nicht" ///
				.c"trifft nicht zu" ///
				.d"Split" ///
				.e"nicht teilgenommen" ///
				.f"nicht in Auswahlgesamtheit" ///
				.g"Interview abgebrochen" ///
				.h"Fehler in Daten" ///
				.i"nicht wahlberechtigt" ///
				.j"nicht waehlen" ///
				.k"keine Erst-/Zweitstimme abgegeben" ///
				.l"ungueltig waehlen" ///
				.m"keine andere Partei waehlen" ///
				.n"noch nicht entschieden" ///
				.o"nicht einzuschaetzen" ///
				.p"nicht bekannt", modify
				}
			}
	}


	
**********************************************************************************************************
********************************************** Recodierung ***********************************************
**********************************************************************************************************

	*** Soziale Gerechtigkeit
		* Gesellschaftliche Gerechtigkeit, Zustand
		* Wenn Sie einmal an den Zustand der Gesellschaft in Deutschland denken - wie gerecht oder ungerecht geht es da alles in allem zu?
		recode q118 (1=4 "sehr gerecht") (2=3 "gerecht") (3=2 "teils/teils") (4=1 "ungerecht") (5=0 "sehr ungerecht"), gen(gerechtigkeit_zustand) 
		gen gerechtigkeit_zustand_st=gerechtigkeit_zustand/4
		label variable gerechtigkeit_zustand_st "Gerechtigkeit, Zustand"
		label variable gerechtigkeit_zustand "Gerechtigkeit, Zustand"
		
		* Gesellschaftliche Gerechtigkeit, Entwicklung
		* Und wie hat sich die Gesellschaft in Deutschland in den letzten Jahren entwickelt? Ist die Gesellschaft wesentlich gerechter geworden, etwas gerechter geworden, gleich geblieben, etwas ungerechter geworden oder wesentlich ungerechter geworden?
		recode q119 (1=4 "wesentlich gerechter") (2=3 "etwas gerechter") (3=2 "gleich geblieben") (4=1 "etwas ungerechter") (5=0 "wesentlich ungerechter"), gen(gerechtigkeit_entwicklung) 
		gen gerechtigkeit_entwicklung_st=gerechtigkeit_entwicklung/4
		label variable gerechtigkeit_entwicklung_st "Gerechtigkeit, Entwicklung"
		label variable gerechtigkeit_entwicklung "Gerechtigkeit, Entwicklung"
					
		* Wichtigkeit einer gerechten Gesellschaft
		* Wie wichtig ist Ihnen persönlich, dass die Politik für eine gerechte Verteilung der Einkommen zwischen den Menschen sorgt?
		recode q121 (5=0 "überhaupt nicht wichtig") (4=1 "nicht so wichtig") (3=2 "mittelmäßig") (2=3 "wichtig") (1=4 "sehr wichtig"), gen(gerechtigkeit_wichtig)
		gen gerechtigkeit_wichtig_st=gerechtigkeit_wichtig/4
		label variable gerechtigkeit_wichtig "Wichtigkeit gerechte Gesellschaft"
		
		* Gerechtigkeit Parteien
		* Welche Partei tut Ihrer Meinung nach am meisten für eine gerechte Einkommensverteilung?
		recode q122a (2=1) (3=1 "CDU/CSU") (4=2 "SPD") (5=3 "FDP") (6=4 "Grüne") (7=5 "Linke") (322=6 "AfD") (808=7 "keine Partei") (801=8 "andere Partei") (809=9 "alle Parteien"), gen(gerechtigkeit_parteien)
		
		* Gerechter Anteil Ego
		* Im Vergleich dazu, wie andere hier in Deutschland leben: Glauben Sie, dass Sie Ihren gerechten Anteil erhalten oder glauben Sie das nicht? Erhalten Sie viel weniger als den gerechten Anteil, etwas weniger, den gerechten Anteil, etwas mehr oder viel mehr als den gerechten Anteil?
		recode q120 (1=0 "viel weniger") (2=1 "etwas weniger") (3=2 "den gerechten Anteil") (4=3 "etwas mehr") (5=4 "viel mehr"), gen(gerechtigkeit_ego) 
		gen gerechtigkeit_ego_st=(gerechtigkeit_ego)/4
		label variable gerechtigkeit_ego_st "Gerechter Anteil, Ego"
		
	*** Wirtschaftliche Lage
		* Bewertung allgemeine wirtschaftliche Lage, retrospektiv
		recode q14 (1=4 "wesentlich besser geworden") (2=3 "etwas besser geworden") (3=2 "gleich geblieben") (4=1 "etwas schlechter geworden") (5=0 "wesentlich schlechter geworden"), gen(awl_retro)
		gen awl_retro_st=awl_retro/4
		label variable awl_retro_st "Allg. wirtschaftliche Lage, retrospektiv"

		* Bewertung allgemeine wirtschaftliche Lage, aktuell
		recode q13 (1=4 "sehr gut") (2=3 "gut") (3=2 "teils/teils") (4=1 "schlecht") (5=0 "sehr schlecht"), gen(awl_aktuell)
		gen awl_aktuell_st=awl_aktuell/4
		label variable awl_aktuell_st "Allg. wirtschaftliche Lage, aktuell"
		
	*** Issue Positionen
		* Eigene Position libertaer-autoritaere Dimension
		gen Zuzug_einschränken=(q79-1)/10
		label variable Zuzug_einschränken "Zuzugsmöglichkeiten einschränken"
		
		* Eigene Position soziooekonomische Dimension
		gen LeistungenvsSteuern=(q78-1)/10
		label variable LeistungenvsSteuern "Sozialstaatl. Leistungen vs. Steuern"
		
		* Die Regierung sollte Maßnahmen ergreifen, um die Einkommensunterschiede zu verringern.
		recode q66d (5=0) (4=1) (3=2) (2=3) (1=4), gen(Einkommensumverteilung)			
		gen Einkommensumverteilung_st=Einkommensumverteilung/4

		* Geben Sie bei den nächsten Fragen bitte an, ob die Staatsausgaben für die einzelnen Bereiche höher oder niedriger sein sollten. 
		* Denken Sie dabei daran, dass dies, wenn Sie "höher" angeben, eine Steuererhöhung und wenn Sie "niedriger" angeben, eine Reduzierung der staatlichen Leistungen zur Folge haben könnte.
		* Und die Staatsausgaben für Sozialleistungen?
		recode q12h (5=0) (4=1) (3=2) (2=3) (1=4), gen(Ausgaben_Sozialleistungen)		
		gen	Ausgaben_Sozialleistungen_st=Ausgaben_Sozialleistungen/4

		* Faktorenanalyse der Fragen zu Umverteilung und Sozialstaat
		factor Einkommensumverteilung_st LeistungenvsSteuern Ausgaben_Sozialleistungen, pcf
		rotate, oblique oblimin
		predict Umverteilung

		sum Umverteilung, detail
		gen Umverteilung_st=(Umverteilung-r(min))/(r(max)-r(min))
		label variable Umverteilung_st "Umverteilung" 		

	*** Soziodemographie
		* Bildung (Schulabschluss)
		recode q135 (1 2=0) (3=1) (4 5=2) (6=.) (9=.), gen(Bildung)
		label define Bildung 0 "Bildung niedrig" 1 "Bildung mittel"  2 "Bildung hoch" 
		label values Bildung Bildung 

		* Alter
		gen Alter=2017-q2c
		gen Alter_durch10=Alter/10
		label variable Alter_durch10 "Alter/10"

		* Geschlecht
		recode q1 (1=1) (2=0), gen(Mann)
		label variable Mann "Geschlecht: Mann"

	*** Parteiidentifikation
		clonevar PID=q125a
		recode PID (2=1) (3=1) (801 808 .b=0) // Zusammenfassen von CDU und CSU; Zusammenfassen von sonstige, keine und weiß nicht zu einer Referenzkategorie

	*** Zweitstimme
		* Zweitstimme recall
		recode q19ba (1=1 "CDU/CSU") (4=2 "SPD") (5=3 "FDP") (6=4 "GRÜNE") (7=5 "DIE LINKE") (322=6 "AfD") (801=7 "Sonstige"), gen(zweitstimme)

	*** Demokratiezufriedenheit
		recode q124 (5=0) (4=1) (3=2) (2=3) (1=4), gen(Demokratiezufriedenheit)			
		gen Demokratiezufriedenheit_st=Demokratiezufriedenheit/4
		
		
		
		
**********************************************************************************************************
************************************** Deskriptive Befunde ***********************************************
**********************************************************************************************************


	* Histogramme: Entwicklung Gerechtigkeit und allgemeine wirtschaftliche Lage (retrospektiv)
		* allgemeine wirtschaftliche Lage, retrospektiv 
		hist awl_retro, percent addlabel addlabopts(mlabsize(small) yvarformat(%4.1f) mlabgap(zero)) ///
				discrete xlabel(0 "wesentlich schlechter" 1 "etwas schlechter" 2 "gleich geblieben" 3 "etwas besser" 4 "wesentlich besser", angle(025)) ytitle("Prozent") xtitle(" ", size(zero)) ///
				title("Und ist die allgemeine wirtschaftliche Lage in Deutschland in den letzten ", size(med)) ///
				title("zwölf Monaten wesentlich besser geworden, etwas besser geworden, gleich geblieben, ", suffix size(med)) ///
				title("etwas schlechter oder wesentlich schlechter geworden?", suffix size(med)) ///
				scheme(plotplainblind) ///
				name(gr1, replace) nodraw

		* Entwicklung Gerechtigkeit
		hist gerechtigkeit_entwicklung, percent addlabel addlabopts(mlabsize(small) yvarformat(%4.1f) mlabgap(zero)) ///
				discrete xlabel(0 "wesentlich ungerechter" 1 "etwas ungerechter" 2 "gleich geblieben" 3 "etwas gerechter" 4 "wesentlich gerechter", angle(025)) ytitle("Prozent") xtitle(" ", size(zero)) ///
				title("Und wie hat sich die Gesellschaft in Deutschland in den letzten Jahren entwickelt?", size(med)) ///
				title("Ist die Gesellschaft wesentlich gerechter geworden, etwas gerechter geworden,", suffix size(med)) ///
				title("gleich geblieben, etwas ungerechter geworden oder wesentlich ungerechter geworden?", suffix size(med)) ///
				scheme(plotplainblind) ///
				name(gr2, replace) nodraw

		graph combine gr1 gr2, ycommon rows(2) iscale(*1.5) imargin(tiny)
				graph export Abbildung2.pdf, replace
		
		
				* Histogramme: ZUSTAND Gerechtigkeit und allgemeine wirtschaftliche Lage (nicht als Abbildung im Paper, s. aber Fußnote)
					* allgemeine wirtschaftliche Lage, aktuell
					hist awl_aktuell, percent addlabel addlabopts(mlabsize(small) yvarformat(%4.1f) mlabgap(zero)) ///
							discrete xlabel(0 "sehr schlecht" 1 "schlecht" 2 "teils/teils" 3 "gut" 4 "sehr gut", angle(025)) ytitle("Prozent") xtitle(" ", size(zero)) ///
							title("Wie beurteilen Sie ganz allgemein die derzeitige wirtschaftliche Lage in Deutschland?", size(medsmall)) ///
							scheme(plotplainblind) ///
							name(gr1, replace) nodraw
				
					* Entwicklung Gerechtigkeit
					hist gerechtigkeit_zustand, percent addlabel addlabopts(mlabsize(small) yvarformat(%4.1f) mlabgap(zero)) ///
							discrete xlabel(0 "sehr ungerecht" 1 "ungerecht" 2 "teils/teils" 3 "gerecht" 4 "sehr gerecht", angle(025)) ytitle("Prozent") xtitle(" ", size(zero)) ///
							title("Wenn Sie einmal an den Zustand der Gesellschaft in Deutschland denken - ", size(medsmall)) ///
							title("wie gerecht oder ungerecht geht es da alles in allem zu?", suffix size(medsmall)) ///
							scheme(plotplainblind) ///
							name(gr2, replace) nodraw

					graph combine gr1 gr2, ycommon rows(2) iscale(*1.3) imargin(tiny)

		
	* Histogramm: Wichtigkeit einer gerechten Gesellschaft
		hist gerechtigkeit_wichtig, percent discrete addlabel addlabopts(mlabsize(small) yvarformat(%4.1f) mlabgap(zero)) ///
				xlabel(0 "überhaupt nicht wichtig" 1 "nicht so wichtig" 2 "mittelmäßig" 3 "wichtig" 4 "sehr wichtig", angle(025)) ytitle("Prozent") xtitle(" ", size(zero)) ///
				title("Wie wichtig ist Ihnen persönlich, dass die Politik für eine gerechte Verteilung", size(med)) ///
				title("der Einkommen zwischen den Menschen sorgt?", suffix size(med)) ///
				scheme(plotplainblind) xsize(7) ///
				name(gr3, replace) nodraw
		
	* Histogramm: Welche Partei tut Ihrer Meinung nach am meisten für eine gerechte Einkommensverteilung?
		hist gerechtigkeit_parteien, discrete percent addlabel addlabopts(mlabsize(small) yvarformat(%4.1f) mlabgap(zero)) ///
				xlabel(1 "CDU/CSU" 2 "SPD" 3 "FDP" 4 "Grüne" 5 "Linke" 6 "AfD" 7 "keine Partei" 8 "andere Partei" 9 "alle Parteien", angle(025)) ///
				ytitle("Prozent") xtitle(" ", size(zero)) ///
				title("Welche Partei tut Ihrer Meinung nach am meisten für", size(med)) ///
				title("eine gerechte Einkommensverteilung?", suffix size(med)) ///
				scheme(plotplainblind) xsize(7) ///
				name(gr4, replace) nodraw
		
		graph combine gr3 gr4, ycommon rows(2) iscale(*1.5) imargin(tiny)
				graph export Abbildung3.pdf, replace

				
	
	
********************************************************************************
********************************* Regressionsanalyse ***************************
********************************************************************************

***** Baseline-Modell *****
	mlogit zweitstimme gerechtigkeit_entwicklung_st awl_retro_st gerechtigkeit_ego_st Umverteilung_st Zuzug_einschränken i.Bildung Alter_durch10 i.ostwest i.Mann i.PID, baseoutcome(2)
		estimates store m1  
		
	* Tabelle 1
		esttab m1 ///
		using Table_m1.rtf, b(%8.2f) se(%8.2f) star(* 0.05 ** 0.01 *** 0.001) varwidth(20) nogaps compress ///
		drop(0.PID 0.Bildung 0.Mann 0.ostwest) /// 
		unstack noomitted ///
		nonumbers replace ///
		label ///
		addnotes("Notes: Reported are coefficients from multinomial logit with standard errors in parentheses; baseline outcome category is CDU/CSU.")
		
	* Berechnung durchschnittlicher marginaler Effekte
		forvalues p = 1/6 {
					estimate restore m1
					margins, dydx(gerechtigkeit_entwicklung_st awl_retro_st gerechtigkeit_ego_st Umverteilung_st Zuzug_einschränken) predict(outcome(`p')) post
					estimate store AME_`p'
					}	
			
	* Abbildung 4 
		coefplot AME_1 || AME_2 || AME_3 || AME_4 || AME_5 || AME_6, ///  
			xline(0) bylabels("CDU/CSU" "SPD" "FDP" "GRÜNE" "LINKE" "AfD") byopts(cols(3)) subtitle(, size(medlarge)) ///
			levels(95 90) ///
			ylabel( , labsize(medlarge)) xsize(6) ///
			xlabel(-.2 (.1) .2, labsize(medlarge)) ///
			coeflabels(gerechtigkeit_entwicklung_st="Soziale Gerechtigkeit" awl_retro_st="Allg. wirt. Lage" gerechtigkeit_ego_st="Gerechter Anteil, Ego" Umverteilung_st="Umverteilung" Zuzug_einschränken="Zuzug einschränken") ///
			scheme(plotplainblind) 

			graph export Abbildung4.pdf, replace

			
			
***** Modelle zur Robustheitsprüfung ****		
	* Modell ohne Parteiidentifikation
		mlogit zweitstimme gerechtigkeit_entwicklung_st awl_retro_st gerechtigkeit_ego_st Umverteilung_st Zuzug_einschränken i.Bildung Alter_durch10 i.ostwest i.Mann
		estimates store m1  
	
		* Berechnung durchschnittlicher marginaler Effekte
			forvalues p = 1/6 {
					estimate restore m1
					margins, dydx(gerechtigkeit_entwicklung_st awl_retro_st gerechtigkeit_ego_st Umverteilung_st Zuzug_einschränken) predict(outcome(`p')) post
					estimate store AME_`p'
					}	
		* Abbildung 
			coefplot AME_1 || AME_2 || AME_3 || AME_4 || AME_5 || AME_6, ///  
				xline(0) bylabels("CDU/CSU" "SPD" "FDP" "GRÜNE" "LINKE" "AfD") byopts(cols(3)) subtitle(, size(medlarge)) ///
				levels(95 90) ///
				ylabel( , labsize(medlarge)) xsize(6) ///
				xlabel(-.2 (.1) .2, labsize(medlarge)) ///
				coeflabels(gerechtigkeit_entwicklung_st="Soziale Gerechtigkeit" awl_retro_st="Allg. wirt. Lage" gerechtigkeit_ego_st="Gerechter Anteil, Ego" Umverteilung_st="Umverteilung" Zuzug_einschränken="Zuzug einschränken") ///
				scheme(plotplainblind) 
			
			
	* Modell mit Items zu aktuellem Zustand, statt retrospektiver Veränderung
		mlogit zweitstimme gerechtigkeit_zustand_st awl_aktuell_st gerechtigkeit_ego_st Umverteilung_st Zuzug_einschränken i.Bildung Alter_durch10 i.ostwest i.Mann i.PID 
		estimates store m1  
	
		* Berechnung durchschnittlicher marginaler Effekte
			forvalues p = 1/6 {
					estimate restore m1
					margins, dydx(gerechtigkeit_zustand_st awl_aktuell_st gerechtigkeit_ego_st Umverteilung_st Zuzug_einschränken) predict(outcome(`p')) post
					estimate store AME_`p'
					}	
		* Abbildung 
			coefplot AME_1 || AME_2 || AME_3 || AME_4 || AME_5 || AME_6, ///  
				xline(0) bylabels("CDU/CSU" "SPD" "FDP" "GRÜNE" "LINKE" "AfD") byopts(cols(3)) subtitle(, size(medlarge)) ///
				levels(95 90) ///
				ylabel( , labsize(medlarge)) xsize(6) ///
				xlabel(-.2 (.1) .2, labsize(medlarge)) ///
				coeflabels(gerechtigkeit_entwicklung_st="Soziale Gerechtigkeit" awl_retro_st="Allg. wirt. Lage" gerechtigkeit_ego_st="Gerechter Anteil, Ego" Umverteilung_st="Umverteilung" Zuzug_einschränken="Zuzug einschränken") ///
				scheme(plotplainblind) 				
		
	
	* Modell mit Demokratiezufriedenheit
		mlogit zweitstimme gerechtigkeit_entwicklung_st awl_retro_st gerechtigkeit_ego_st Umverteilung_st Zuzug_einschränken Demokratiezufriedenheit_st i.Bildung Alter_durch10 i.ostwest i.Mann i.PID
		estimates store m1  
	
		* Berechnung durchschnittlicher marginaler Effekte
			forvalues p = 1/6 {
					estimate restore m1
					margins, dydx(gerechtigkeit_entwicklung_st awl_retro_st gerechtigkeit_ego_st Umverteilung_st Zuzug_einschränken Demokratiezufriedenheit_st) predict(outcome(`p')) post
					estimate store AME_`p'
					}	
		* Abbildung 
			coefplot AME_1 || AME_2 || AME_3 || AME_4 || AME_5 || AME_6, ///  
				xline(0) bylabels("CDU/CSU" "SPD" "FDP" "GRÜNE" "LINKE" "AfD") byopts(cols(3)) subtitle(, size(medlarge)) ///
				levels(95 90) ///
				ylabel( , labsize(medlarge)) xsize(6) ///
				xlabel(-.2 (.1) .2, labsize(medlarge)) ///
				coeflabels(gerechtigkeit_entwicklung_st="Soziale Gerechtigkeit" awl_retro_st="Allg. wirt. Lage" gerechtigkeit_ego_st="Gerechter Anteil, Ego" Umverteilung_st="Umverteilung" Zuzug_einschränken="Zuzug einschränken") ///
				scheme(plotplainblind) 	
				

***** Modell mit Interaktionsterm: Gerechtigkeitsentwicklung X Umverteilung ****		
		mlogit zweitstimme c.gerechtigkeit_entwicklung_st##c.Umverteilung_st awl_retro_st gerechtigkeit_ego_st Zuzug_einschränken Demokratiezufriedenheit_st i.Bildung Alter_durch10 i.ostwest i.Mann i.PID
		estimates store m1  

* Vorhergesagte wahrscheinlichkeiten über wahrgenommene Entwicklung der Gerechtigkeit 
		forvalues p = 1/1 {
		
		estimate restore m1
			margins, at(gerechtigkeit_entwicklung_st=(0 (0.25) 1) Umverteilung_st=(0.34 0.90)) predict(outcome(`p')) level(84) post
			if `p'==1  local title="CDU/CSU" 		
			marginsplot, ///
					legend(off) ///
					xtitle("Soziale Gerechtigkeit, Entwicklung") ytitle(" ") ///
					title("`title'", size(medlarge))  ///
					text(.45 .5 "gegen Umverteilung", size(small)) text(.22 .64 "pro Umverteilung", size(small) color(gs8)) ///
					addplot(hist gerechtigkeit_entwicklung_st if e(sample) & zweitstimme==`p', fcolor(none) percent discrete yaxis(2) ///
					yscale(alt range(0 110) axis(2)) ylabel(none, axis(2)) ytitle(" ", size(zero) axis(2)) ylabel(0 (.1) 0.5) ///
					xlabel(0 "  wesentl. ungerechter" 0.25 " " 0.5 " " 0.75 " " 1 "wesentl. gerechter  "))  ///
					scheme(plotplainblind) ///
					name(predicted`p', replace) 				
			}
		
		
			forvalues p = 2/7 {
		estimate restore m1
			margins, at(gerechtigkeit_entwicklung_st=(0 (0.25) 1) Umverteilung_st=(0.34 0.90)) predict(outcome(`p')) level(84) post
			if `p'==2  local title="SPD" 
			if `p'==3  local title="FDP" 
			if `p'==4  local title="GRÜNE" 
			if `p'==5  local title="LINKE" 
			if `p'==6  local title="AfD" 
			if `p'==7  local title="Sonstige" 
			marginsplot, ///
					legend(off) ///
					xtitle("Soziale Gerechtigkeit, Entwicklung") ytitle(" ") ///
					title("`title'", size(medlarge)) ///
					addplot(hist gerechtigkeit_entwicklung_st if e(sample) & zweitstimme==`p', fcolor(none) percent discrete yaxis(2) ///
					yscale(alt range(0 110) axis(2)) ylabel(none, axis(2)) ytitle(" ", size(zero) axis(2)) ylabel(0 (.1) 0.5) ///
					xlabel(0 "  wesentl. ungerechter" 0.25 " " 0.5 " " 0.75 " " 1 "wesentl. gerechter  "))  ///
					scheme(plotplainblind) ///
					name(predicted`p', replace) 				
			}
			
		graph combine predicted1 predicted2 predicted3 predicted4 predicted5 predicted6, xcommon imargin(zero) iscale(*1.25) ///
			 rows(2) 
 			graph export Abbildung5.pdf, replace
